@extends($theme.'layouts.user')
@section('title',trans('Dashboard'))
@section('content')
    <div class="pagetitle">
        <h3 class="mb-1">@lang('Dashboard')</h3>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{route('user.dashboard')}}">@lang('Home')</a></li>
                <li class="breadcrumb-item active">@lang('Dashboard')</li>
            </ol>
        </nav>
    </div>
    @if(basicControl()->push_notification && $firebaseNotify)
        <div class="section dashboard">
            <div class="row" id="firebase-app">
                <div v-if="user_foreground == '1' || user_background == '1'" class="card-box">
                    <div v-if="notificationPermission == 'default' && !is_notification_skipped" v-cloak>
                        <div class="media align-items-center d-flex justify-content-between alert alert-warning mb-4">
                            <div>
                                <i class="fas fa-exclamation-triangle me-2"></i>
                                @lang('Do not miss any single important notification! Allow your browser to get instant push notification')
                                <button class="btn-2 ms-2" id="allow-notification"> @lang('Allow me') <span></span>
                                </button>
                            </div>
                            <button class="close-btn pt-1" @click.prevent="skipNotification"><i
                                    class="fas fa-times"></i>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="card-box" v-if="notificationPermission == 'denied' && !is_notification_skipped" v-cloak>
                    <div class="media align-items-center d-flex justify-content-between alert alert-warning mb-4">
                        <div>
                            <i class="fas fa-exclamation-triangle"></i> @lang('Please allow your browser to get instant push notification. Allow it from notification setting.')
                        </div>
                        <button class="close-btn pt-1" @click.prevent="skipNotification"><i class="fas fa-times"></i>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    @endif


    <div class="section dashboard">
        <div class="row g-4">
            <div class="col-md-12">
                @php
                    $rank = auth()->user()->rank??null;
                    $class = $rank?'col-xl-3':'col-xl-4';
                @endphp

                <div class="mobile-view">
                    <div class="swiper-container">
                        <div class="swiper four-item-carousel">
                            <div class="swiper-wrapper">
                                <div class="swiper-slide">
                                    <div class="box-card grayish-blue-card moduleRecord">
                                        <div class="top">
                                            <div class="icon-box">
                                                <i class="fa-solid fa-dollar-sign"></i>
                                            </div>
                                            <div class="text-box">
                                                <h5 class="title">@lang('Balance')</h5>
                                            </div>
                                        </div>
                                        <div class="bottom">
                                            <div class="item" data-bs-toggle="tooltip" data-bs-placement="top"
                                                 title="@lang('Wallet Balance')">
                                    <span
                                        class="unAnsweredChat">{{currencyPosition(auth()->guard('web')->user()->balance??0)}}</span>
                                            </div>

                                            <div class="item" data-bs-toggle="tooltip" data-bs-placement="top"
                                                 title="@lang('Profit Balance')">
                                    <span
                                        class="ProjectProfit">{{currencyPosition(auth()->guard('web')->user()->profit_balance??0)}}</span>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                                <div class="swiper-slide">
                                    <div class="box-card grayish-blue-card moduleRecord">
                                        <div class="top">
                                            <div class="icon-box">
                                                <i class="fa-solid fa-dollar-sign"></i>
                                            </div>
                                            <div class="text-box">
                                                <h5 class="title">@lang('Balance')</h5>
                                            </div>
                                        </div>
                                        <div class="bottom">
                                            <div class="item" data-bs-toggle="tooltip" data-bs-placement="top"
                                                 title="@lang('Wallet Balance')">
                                    <span
                                        class="unAnsweredChat">{{currencyPosition(auth()->guard('web')->user()->balance??0)}}</span>
                                            </div>

                                            <div class="item" data-bs-toggle="tooltip" data-bs-placement="top"
                                                 title="@lang('Profit Balance')">
                                    <span
                                        class="ProjectProfit">{{currencyPosition(auth()->guard('web')->user()->profit_balance??0)}}</span>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                                <div class="swiper-slide">
                                    <div class="box-card strong-orange-card moduleRecord">
                                        <div class="top">
                                            <div class="icon-box">
                                                <i class="fa-light fa-chart-network"></i>
                                            </div>
                                            <div class="text-box">
                                                <h5 class="title">@lang('Invest Statistics')</h5>
                                            </div>
                                        </div>
                                        <div class="bottom">
                                            <div class="item" data-bs-toggle="tooltip" data-bs-placement="top"
                                                 title="@lang('Total Invest')">
                                    <span
                                        class="project_invest">{{currencyPosition(auth()->guard('web')->user()->total_invest??0)}}</span>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                                <div class="swiper-slide">
                                    <div class="box-card strong-orange-card moduleRecord">
                                        <div class="top">
                                            <div class="icon-box">
                                                <i class="fa-light fa-money-bill-wave"></i>
                                            </div>
                                            <div class="text-box">
                                                <h5 class="title">@lang('Withdraw Statistics')</h5>

                                            </div>
                                        </div>
                                        <div class="bottom">
                                            <div class="item" data-bs-toggle="tooltip" data-bs-placement="top"
                                                 title="Total Payout">
                                                <span class="totalProperty">{{currencyPosition($total_withdraw??0)}}</span>
                                            </div>
                                            <div class="item" data-bs-toggle="tooltip" data-bs-placement="top"
                                                 title="Last Payout">
                                    <span
                                        class="totalVisitors">{{currencyPosition($last_withdraw->amount_in_base_currency??0)}}</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="swiper-slide">
                                    <div class="box-card grayish-blue-card moduleRecord">
                                        <div class="top">
                                            <div class="icon-box">
                                                <i class="fa-regular fa-user-headset"></i>
                                            </div>
                                            <div class="text-box">
                                                <h5 class="title">@lang('Ticket Statistics')</h5>
                                            </div>
                                        </div>
                                        <div class="bottom">
                                            <div class="item" data-bs-toggle="tooltip" data-bs-placement="top"
                                                 title="@lang('Pending Ticket')">
                                                <i class="fa-regular fa-spinner"></i>
                                                <span class="pendingTicket">{{$pending_ticket}}</span>
                                            </div>
                                            <div class="item" data-bs-toggle="tooltip" data-bs-placement="top"
                                                 title="Answered Ticket">
                                                <i class="fa-regular fa-book-open"></i>
                                                <span class="openTicket">{{$answered_ticket}}</span>
                                            </div>
                                            <div class="item" data-bs-toggle="tooltip" data-bs-placement="top"
                                                 title="Closed Ticket">
                                                <i class="fa-regular fa-box-check"></i>
                                                <span class="closeTicket">{{$closed_ticket}}</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="swiper-slide">
                                    @if($rank)
                                        <div class="box-card grayish-custom-card moduleRecord">
                                            <div class="top">
                                                <div class="icon-box">
                                                    <i class="fa-regular fa-badge-check"></i>
                                                </div>
                                                <div class="text-box">
                                                    <h5 class="title">@lang('Current Badge')</h5>
                                                </div>
                                            </div>
                                            <div class="bottom">
                                                <div class="item"
                                                >
                                                    <span class="unAnsweredChat">{{$rank->rank_lavel}}</span>
                                                </div>

                                                <div class="item"
                                                >
                                                    <span class="ProjectProfit">{{$rank->rank_name}}</span>
                                                </div>

                                            </div>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


                <div class="desktop-view">
                    <div class="row g-4">
                        <div class="col-xl-3 col-sm-6">
                            <div class="box-card grayish-blue-card moduleRecord">
                                <div class="top">
                                    <div class="icon-box">
                                        <i class="fa-solid fa-dollar-sign"></i>
                                    </div>
                                    <div class="text-box">
                                        <h5 class="title">@lang('Balance')</h5>
                                    </div>
                                </div>
                                <div class="bottom">
                                    <div class="item" data-bs-toggle="tooltip" data-bs-placement="top"
                                         title="@lang('Wallet Balance')">
                                    <span
                                        class="unAnsweredChat">{{currencyPosition(auth()->guard('web')->user()->balance??0)}}</span>
                                    </div>

                                    <div class="item" data-bs-toggle="tooltip" data-bs-placement="top"
                                         title="@lang('Profit Balance')">
                                    <span
                                        class="ProjectProfit">{{currencyPosition(auth()->guard('web')->user()->profit_balance??0)}}</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-3 col-sm-6">
                            <div class="box-card grayish-green-card moduleRecord">
                                <div class="top">
                                    <div class="icon-box">
                                        <i class="fa-light fa-file-chart-pie"></i>
                                    </div>
                                    <div class="text-box">
                                        <h5 class="title">@lang('Profit Statistics')</h5>
                                    </div>
                                </div>
                                <div class="bottom">
                                    <div class="item" data-bs-toggle="tooltip" data-bs-placement="top"
                                         title="@lang('Total Profit')">
                                    <span
                                        class="planProfit">{{currencyPosition(auth()->guard('web')->user()->total_profit??0)}}</span>
                                    </div>

                                </div>
                            </div>
                        </div>
                        <div class="col-xl-3 col-sm-6">
                            <div class="box-card strong-orange-card moduleRecord">
                                <div class="top">
                                    <div class="icon-box">
                                        <i class="fa-light fa-chart-network"></i>
                                    </div>
                                    <div class="text-box">
                                        <h5 class="title">@lang('Invest Statistics')</h5>
                                    </div>
                                </div>
                                <div class="bottom">
                                    <div class="item" data-bs-toggle="tooltip" data-bs-placement="top"
                                         title="@lang('Total Invest')">
                                    <span
                                        class="project_invest">{{currencyPosition(auth()->guard('web')->user()->total_invest??0)}}</span>
                                    </div>

                                </div>
                            </div>
                        </div>
                        <div class="col-xl-3 col-sm-6">
                            <div class="box-card strong-orange-card moduleRecord">
                                <div class="top">
                                    <div class="icon-box">
                                        <i class="fa-light fa-money-bill-wave"></i>
                                    </div>
                                    <div class="text-box">
                                        <h5 class="title">@lang('Withdraw Statistics')</h5>

                                    </div>
                                </div>
                                <div class="bottom">
                                    <div class="item" data-bs-toggle="tooltip" data-bs-placement="top"
                                         title="Total Payout">
                                        <span class="totalProperty">{{currencyPosition($total_withdraw??0)}}</span>
                                    </div>
                                    <div class="item" data-bs-toggle="tooltip" data-bs-placement="top"
                                         title="Last Payout">
                                    <span
                                        class="totalVisitors">{{currencyPosition($last_withdraw->amount_in_base_currency??0)}}</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


                <div class="mt-30">
                    <div class="row g-4">
                        <div class="col-xl-8">
                            <div class="card rounded-4 " id="investHistoryCard">
                                <div class="card-header d-flex justify-content-between flex-wrap">
                                    <h4 class="card-header-title">
                                        @lang('Invest History & Referral Bonus')
                                    </h4>
                                    <button id="" class="btn btn-white btn-sm dropdown-toggle js-daterangepicker-predefined">
                                        <i class="bi-calendar-week"></i>
                                        <span class="js-daterangepicker-predefined-preview  ms-1"></span>
                                    </button>
                                </div>
                                <div class="card-box">
                                    <div id="investHistory"></div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-4 desktop-view">
                            <h4 class="mb-20">@lang('Others')</h4>
                            <div class="row g-4 ">
                                <div class="col-xl-12 col-sm-6">
                                    <div class="box-card grayish-blue-card moduleRecord">
                                        <div class="top">
                                            <div class="icon-box">
                                                <i class="fa-regular fa-user-headset"></i>
                                            </div>
                                            <div class="text-box">
                                                <h5 class="title">@lang('Ticket Statistics')</h5>
                                            </div>
                                        </div>
                                        <div class="bottom">
                                            <div class="item" data-bs-toggle="tooltip" data-bs-placement="top"
                                                 title="@lang('Pending Ticket')">
                                                <i class="fa-regular fa-spinner"></i>
                                                <span class="pendingTicket">{{$pending_ticket}}</span>
                                            </div>
                                            <div class="item" data-bs-toggle="tooltip" data-bs-placement="top"
                                                 title="Answered Ticket">
                                                <i class="fa-regular fa-book-open"></i>
                                                <span class="openTicket">{{$answered_ticket}}</span>
                                            </div>
                                            <div class="item" data-bs-toggle="tooltip" data-bs-placement="top"
                                                 title="Closed Ticket">
                                                <i class="fa-regular fa-box-check"></i>
                                                <span class="closeTicket">{{$closed_ticket}}</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-12 col-sm-6">
                                    @if($rank)
                                        <div class="box-card grayish-custom-card moduleRecord">
                                            <div class="top">
                                                <div class="icon-box">
                                                    <i class="fa-regular fa-badge-check"></i>
                                                </div>
                                                <div class="text-box">
                                                    <h5 class="title">@lang('Current Badge')</h5>
                                                </div>
                                            </div>
                                            <div class="bottom">
                                                <div class="item"
                                                >
                                                    <span class="unAnsweredChat">{{$rank->rank_lavel}}</span>
                                                </div>

                                                <div class="item"
                                                >
                                                    <span class="ProjectProfit">{{$rank->rank_name}}</span>
                                                </div>

                                            </div>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="mt-30">
                    <h5 class="mb-20">@lang('Recent Activity (7 Days)')</h5>
                    <div class="card">
                        <div class="card-body">
                            <div class="row g-4">
                                <div class="col-xxl-3  col-md-6 col-sm-6">
                                    <div class="transaction-box activity-card">
                                        <div class="icon-box">
                                            <i class="fa-regular fa-user-headset"></i>
                                        </div>
                                        <div class="text-box">
                                            <h5 class="mb-0">{{$recentTickets}}</h5>
                                            <p class="mb-0">@lang('Support')</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xxl-3  col-md-6 col-sm-6">
                                    <div class="transaction-box activity-card">
                                        <div class="icon-box">
                                            <i class="fa-light fa-money-bill-wave"></i>
                                        </div>
                                        <div class="text-box">
                                            <h5 class="mb-0">{{currencyPosition($recent_withdraw)}}</h5>
                                            <p class="mb-0">@lang('Withdraw')</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xxl-3  col-md-6 col-sm-6 ">
                                    <div class="transaction-box activity-card">
                                        <div class="icon-box">
                                            <i class="fa-regular fa-notes-medical"></i>
                                        </div>
                                        <div class="text-box">
                                            <h5 class="mb-0">{{currencyPosition($recent_plan_invest)}}</h5>
                                            <p class="mb-0">@lang('Invest')</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xxl-3  col-md-6 col-sm-6">
                                    <div class="transaction-box activity-card">
                                        <div class="icon-box">
                                            <i class="fal fa-chart-line"></i>
                                        </div>
                                        <div class="text-box">
                                            <h5 class="mb-0">{{currencyPosition($recent_deposit)}}</h5>
                                            <p class="mb-0">@lang('Deposit')</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>

        </div>

        <div class="mt-30">
            <div class="row g-4">
                <div class="col-xl-6 col-lg-12">
                    <div class="card rounded-4 " id="depositPayoutHistoryCard">
                        <div class="card-header bg-white d-flex flex-wrap justify-content-between">
                            <h4 class="card-header-title">
                                @lang('Deposit & Payout History')
                            </h4>
                            <button id="" class="btn btn-white btn-sm dropdown-toggle js-daterangepicker-deposit-payout-predefined">
                                <i class="bi-calendar-week"></i>
                                <span class="js-daterangepicker-deposit-payout-predefined-preview  ms-1"></span>
                            </button>
                        </div>
                        <div class="card-box">
                            <div id="depositPayoutHistory"></div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-6 col-lg-12">
                    <div class="card rounded-4 " id="TransactionHistoryCard">
                        <div class="card-header bg-white d-flex flex-wrap justify-content-between">
                            <h4 class="card-header-title">
                                @lang('Transaction Summary')
                            </h4>
                            <button id="" class="btn btn-white btn-sm dropdown-toggle js-daterangepicker-transaction-predefined">
                                <i class="bi-calendar-week"></i>
                                <span class="js-daterangepicker-transaction-predefined-preview  ms-1"></span>
                            </button>
                        </div>
                        <div class="card-box">
                            <div id="transactionHistory"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('js-lib')
    <script src="{{ asset('assets/admin/js/moment.min.js') }}"></script>
    <script src="{{ asset('assets/global/js/daterangepicker.min.js') }}"></script>
    <script src="{{ asset('assets/admin/js/tom-select.complete.min.js') }}"></script>
@endpush

@push('css-lib')
    <link rel="stylesheet" href="{{ asset('assets/admin/css/tom-select.bootstrap5.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/global/css/daterangepicker.css') }}">
@endpush

@push('script')
    <script>
        $(document).ready(function () {
            Notiflix.Block.standard('#investHistoryCard');
            Notiflix.Block.standard('#depositPayoutHistoryCard');
            Notiflix.Block.standard('#TransactionHistoryCard');

            function cb(start, end) {
                $('.js-daterangepicker-predefined-preview').html(start.format('MMM D') + ' - ' + end.format('MMM D, YYYY'));
            }

            function cb2(start, end){
                $('.js-daterangepicker-deposit-payout-predefined-preview').html(start.format('MMM D') + ' - ' + end.format('MMM D, YYYY'));

            }
            function cb3(start, end){
                $('.js-daterangepicker-transaction-predefined-preview').html(start.format('MMM D') + ' - ' + end.format('MMM D, YYYY'));

            }

            $('.js-daterangepicker-predefined').daterangepicker({
                startDate: moment().startOf('month'),
                endDate: moment().endOf('month'),
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                }
            }, cb);

            $('.js-daterangepicker-deposit-payout-predefined').daterangepicker({
                startDate: moment().startOf('month'),
                endDate: moment().endOf('month'),
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                }
            }, cb2);

            $('.js-daterangepicker-transaction-predefined').daterangepicker({
                startDate: moment().startOf('month'),
                endDate: moment().endOf('month'),
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                }
            }, cb3);

            // Initialize the daterange preview with default values
            cb(moment().startOf('month'), moment().endOf('month'));
            cb2(moment().startOf('month'), moment().endOf('month'));
            cb3(moment().startOf('month'), moment().endOf('month'));

            // Define chart options
            var options = {
                series: [{
                    name: 'Plan Invest',
                    data: []
                },
                    {
                        name: "Referral Bonus",
                        data: []
                    }
                ],
                chart: {
                    type: 'bar',
                    height: 410,
                    toolbar: {
                        show: false
                    }
                },
                plotOptions: {
                    bar: {
                        horizontal: false,
                        columnWidth: '50%', // Adjusted for equal spacing
                        borderRadius: 5,
                        endingShape: 'rounded'
                    },
                },
                dataLabels: {
                    enabled: false
                },
                stroke: {
                    show: true,
                    width: 2,
                    colors: ['transparent']
                },
                xaxis: {
                    categories: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
                },
                fill: {
                    opacity: 1
                },
                tooltip: {
                    y: {
                        formatter: function (val) {
                            return currencyPosition(val);
                        }
                    }
                },
                colors: ['#5B8FF9', '#6C757D']
            };

            var chart = new ApexCharts(document.querySelector("#investHistory"), options);
            chart.render();

            async function InvestHistory() {
                let dateRange = $('.js-daterangepicker-predefined').data('daterangepicker');
                let startDate = dateRange.startDate.format('YYYY-MM-DD');
                let endDate = dateRange.endDate.format('YYYY-MM-DD');

                try {
                    const response = await axios.get('{{route('user.invest.history')}}', {
                        params: {
                            start_date: startDate,
                            end_date: endDate
                        }
                    });
                    // Update chart with new data
                    if (response.data && response.data.labels && response.data.datasets) {
                        chart.updateOptions({
                            xaxis: {
                                categories: response.data.labels
                            }
                        });
                        chart.updateSeries(response.data.datasets);
                    }
                    Notiflix.Block.remove('#investHistoryCard');
                } catch (error) {
                    console.error("Error fetching investment history:", error);
                    Notiflix.Block.remove('#investHistoryCard');
                }
            }

            $('.js-daterangepicker-predefined').on('apply.daterangepicker', InvestHistory);

            InvestHistory();

            var depositPayoutChartOptions = {
                series: [{
                    name: "Deposit",
                    data: []
                },
                    {
                        name: "Payout",
                        data: []
                    }
                ],
                chart: {
                    height: 350,
                    type: 'line',
                    zoom: {
                        enabled: false
                    },
                    toolbar: {
                        show: false,

                    }
                },
                dataLabels: {
                    enabled: false
                },
                stroke: {
                    curve: 'smooth',
                    width: 3
                },

                grid: {
                    row: {
                        colors: ['#f3f3f3', 'transparent'], // takes an array which will be repeated on columns
                        opacity: 0.5
                    },
                },
                xaxis: {
                    categories: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
                },
                colors: ['#5B8FF9', '#6C757D'],
                tooltip: {
                    y: {
                        formatter: function (val) {
                            return currencyPosition(val)
                        }
                    }
                }
            };

            const depositPayoutChart = new ApexCharts(document.querySelector("#depositPayoutHistory"), depositPayoutChartOptions);
            depositPayoutChart.render()

            async function depositPayoutHistory() {
                let dateRange = $('.js-daterangepicker-deposit-payout-predefined').data('daterangepicker');
                let startDate = dateRange.startDate.format('YYYY-MM-DD');
                let endDate = dateRange.endDate.format('YYYY-MM-DD');

                await axios.get('{{route('user.depositPayout.history')}}',{
                    params : {
                        start_date: startDate,
                        end_date: endDate
                    }
                })
                    .then(function (response) {
                        depositPayoutChart.updateOptions({
                            xaxis: {
                                categories: response.data.labels
                            }
                        });

                        let newSeries = [{
                            name: 'Deposit',
                            data: response.data.deposits
                        }, {
                            name: 'Payout',
                            data: response.data.payouts
                        }];
                        depositPayoutChart.updateSeries(newSeries)
                        Notiflix.Block.remove('#depositPayoutHistoryCard');
                    })
                    .catch(function (error) {

                    })
            }

            $('.js-daterangepicker-deposit-payout-predefined').on('apply.daterangepicker', depositPayoutHistory);
            depositPayoutHistory()


            const transactionOptions = {
                series: [{
                    data: []
                }],
                chart: {
                    type: 'bar',
                    height: 350,
                    toolbar: {
                        show: false,

                    }
                },
                plotOptions: {
                    bar: {
                        borderRadius: 4,
                        borderRadiusApplication: 'end',
                        horizontal: true,
                    }
                },
                dataLabels: {
                    enabled: false
                },
                xaxis: {
                    categories: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
                },
                tooltip: {
                    y: {
                        formatter: function (val) {
                            return currencyPosition(val)
                        }
                    }
                },
                colors: ['#5B8FF9', '#6C757D']
            };

            const TransactionChart = new ApexCharts(document.querySelector("#transactionHistory"), transactionOptions);
            TransactionChart.render();



            async function transactionHistory() {
                let dateRange = $('.js-daterangepicker-transaction-predefined').data('daterangepicker');
                let startDate = dateRange.startDate.format('YYYY-MM-DD');
                let endDate = dateRange.endDate.format('YYYY-MM-DD');
                await axios.get('{{route('user.transaction.history')}}',{
                    params : {
                        start_date: startDate,
                        end_date: endDate
                    }
                })
                    .then(function (response) {

                        TransactionChart.updateOptions({
                            xaxis: {
                                categories: response.data.labels
                            }
                        });


                        let newSeries = [{
                            name: 'Transaction',
                            data: response.data.transactions
                        }];
                        TransactionChart.updateSeries(newSeries)
                        Notiflix.Block.remove('#TransactionHistoryCard');
                    })
                    .catch(function (err) {
                        console.error(err)
                    })
            }

            $('.js-daterangepicker-transaction-predefined').on('apply.daterangepicker', transactionHistory);
            transactionHistory()


        })
        $(document).ready(function () {
            $('[data-bs-toggle="tooltip"]').tooltip();

            $('.item').hover(function () {
                $(this).tooltip('show');
            }, function () {
                $(this).tooltip('hide');
            });
        });

    </script>
@endpush

@if(basicControl()->push_notification &&  $firebaseNotify)
    @push('script')
        <script type="module">

            import {initializeApp} from "https://www.gstatic.com/firebasejs/11.0.1/firebase-app.js";
            import {
                getMessaging,
                getToken,
                onMessage
            } from "https://www.gstatic.com/firebasejs/11.0.1/firebase-messaging.js";

            const firebaseConfig = {
                apiKey: "{{$firebaseNotify['apiKey']}}",
                authDomain: "{{$firebaseNotify['authDomain']}}",
                projectId: "{{$firebaseNotify['projectId']}}",
                storageBucket: "{{$firebaseNotify['storageBucket']}}",
                messagingSenderId: "{{$firebaseNotify['messagingSenderId']}}",
                appId: "{{$firebaseNotify['appId']}}",
                measurementId: "{{$firebaseNotify['measurementId']}}"
            };

            const app = initializeApp(firebaseConfig);
            const messaging = getMessaging(app);

            if ('serviceWorker' in navigator) {
                navigator.serviceWorker.register('{{ getProjectDirectory() }}' + '/firebase-messaging-sw.js', {scope: './'})
                    .then(function (registration) {

                        requestPermissionAndGenerateToken(registration);
                    })
                    .catch(function (error) {

                    });
            }

            onMessage(messaging, (payload) => {
                if (payload.data && (payload.data.foreground || parseInt(payload.data.foreground) === 1)) {
                    const title = payload.notification?.title || "Notification";
                    const options = {
                        body: payload.notification?.body || "",
                        icon: payload.notification?.icon || "/default-icon.png",
                    };
                    new Notification(title, options);
                }
            });

            function requestPermissionAndGenerateToken(registration) {
                document.addEventListener("click", function (event) {
                    if (event.target.id === 'allow-notification') {
                        Notification.requestPermission().then((permission) => {
                            if (permission === 'granted') {
                                getToken(messaging, {
                                    serviceWorkerRegistration: registration,
                                    vapidKey: "{{$firebaseNotify['vapidKey']}}"
                                }).then((token) => {

                                    $.ajax({
                                        url: "{{ route('user.save.token') }}",
                                        method: "post",
                                        data: {token: token},
                                        success: function (res) {

                                        },
                                        error: function (error) {

                                        }
                                    });
                                    window.newApp.notificationPermission = 'granted';
                                }).catch((error) => {

                                });
                            } else {
                                window.newApp.notificationPermission = 'denied';
                            }
                        });
                    }
                });
            }

        </script>
        <script>
            window.newApp = new Vue({
                el: "#firebase-app",
                data: {
                    user_foreground: '',
                    user_background: '',
                    notificationPermission: Notification.permission,
                    is_notification_skipped: sessionStorage.getItem('is_notification_skipped') == '1'
                },
                mounted() {
                    sessionStorage.clear();
                    this.user_foreground = "{{$firebaseNotify['user_foreground']}}";
                    this.user_background = "{{$firebaseNotify['user_background']}}";
                },
                methods: {
                    skipNotification() {
                        sessionStorage.setItem('is_notification_skipped', '1')
                        this.is_notification_skipped = true;
                    }
                }
            });
        </script>
    @endpush
@endif

@push('style')
    <style>
        .btn.dropdown-toggle {
            display: -ms-inline-flexbox;
            display: inline-flex;
            -ms-flex-align: center;
            align-items: center;
        }

        .dropdown-toggle {
            position: relative;
            display: -ms-flexbox;
            display: flex;
            -ms-flex-align: center;
            align-items: center;
            overflow: hidden;
        }

        .btn-white {
            background-color: #fff !important;
            border: .0625rem solid rgba(231, 234, 243, .7) !important;
        }

        .dropdown-toggle {
            white-space: nowrap;
        }

        .btn-group-sm > .btn, .btn-sm {
            --bs-btn-padding-y: 0.5rem;
            --bs-btn-padding-x: 1rem;
            --bs-btn-font-size: 0.8125rem;
            --bs-btn-border-radius: 0.3125rem;
        }

        .btn {
            --bs-btn-padding-x: 1rem;
            --bs-btn-padding-y: 0.6125rem;
            --bs-btn-font-size: 0.875rem;
            --bs-btn-font-weight: 400;
            --bs-btn-line-height: 1.5;
            --bs-btn-color: #677788;
            --bs-btn-bg: transparent;
            --bs-btn-border-width: 0.0625rem;
            --bs-btn-border-color: transparent;
            --bs-btn-border-radius: 0.3125rem;
            --bs-btn-hover-border-color: transparent;
            --bs-btn-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.15), 0 1px 1px rgba(0, 0, 0, 0.075);
            --bs-btn-disabled-opacity: 0.65;
            --bs-btn-focus-box-shadow: 0 0 0 0 rgba(var(--bs-btn-focus-shadow-rgb), .5);
            display: inline-block;
            padding: var(--bs-btn-padding-y) var(--bs-btn-padding-x);
            font-family: var(--bs-btn-font-family);
            font-size: var(--bs-btn-font-size);
            font-weight: var(--bs-btn-font-weight);
            line-height: var(--bs-btn-line-height);
            color: var(--bs-btn-color);
            text-align: center;
            vertical-align: middle;
            cursor: pointer;
            -webkit-user-select: none;
            -moz-user-select: none;
            -ms-user-select: none;
            user-select: none;
            border: var(--bs-btn-border-width) solid var(--bs-btn-border-color);
            border-radius: var(--bs-btn-border-radius);
            background-color: var(--bs-btn-bg);
            transition: color .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out;
        }

        .ms-1 {
            margin-left: .25rem !important;
        }

        .report-item:not(:last-child) {
            margin-bottom: 3px;
        }

        .report-item {
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .box-custom {
            padding: 20px;
            background-color: var(--bg-color2);
            border-radius: 25px;
            align-items: center;
            gap: 20px;
        }

        .report-item span {
            font-size: 14px;
            display: inline-block;
        }

        .report-item strong {
            font-size: 14px;
            font-weight: bolder;
        }

        .report-item i {
            font-size: 1.125rem;
            color: rgb(var(--primary-color));
            margin-right: 5px;
        }

        .custom-card {
            height: 400px;
            overflow-y: auto;
            padding: 0 20px !important;
            margin: 20px 0;
        }

        .no-data{
            height: 450px;
        }

    </style>
@endpush

